/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2017 NXP
 * All rights reserved.
 *
 * 
 * SPDX-License-Identifier: BSD-3-Clause
 */


#ifndef SOURCE_LIN_CFG_H_
#define SOURCE_LIN_CFG_H_
   
#include "fsl_lin.h"   

#define LIN_NUM_OF_SLAVE_IFCS    0U
#define LIN_NUM_OF_MASTER_IFCS   1U

/* Size of configuration in ROM and RAM used for interface: LI0 */
#define LI0_LIN_SIZE_OF_CFG      4U

/* Number of frames */
#define LIN_NUM_OF_FRMS          3U

/* Number of interfaces */
#define LIN_NUM_OF_IFCS          1U

/* Maximal timeout to settle in idle state */
#define MAX_IDLE_TIMEOUT_CNT     10000

/* frame buffer size */
#define LIN_FRAME_BUF_SIZE       11U
#define LIN_FLAG_BUF_SIZE        4U

/* Size of each ota block */
#define LIN_OTA_BLOCK_SIZE       1024U

/* lin frames of each ota block */
#define LIN_OTA_FRAMES_OF_BLOCK  (LIN_OTA_BLOCK_SIZE / 8)

typedef enum 
{
    gID_OtapCmd_c = 0x31,
    gID_OtapGetStatus_c,
    gID_OtapData_c
} lin_id_t;

typedef enum
{
    LIN_OTA_CMD_NONE = 0x00,
    LIN_OTA_CMD_START,
    LIN_OTA_CMD_END,
    LIN_OTA_CMD_CONTINUE
} lin_ota_cmd_c;

typedef enum 
{
    LIN_OTA_STATUS_IDLE = 0x00,
    LIN_OTA_STATUS_READY,
    LIN_OTA_STATUS_RUNNING,
    LIN_OTA_STATUS_FINISH,
    LIN_OTA_STATUS_ABORT
} lin_ota_status_t;

typedef enum
{
    LIN_OTA_STAGE_IDLE = 0x00,
    LIN_OTA_STAGE_TX_DATA,
    LIN_OTA_STAGE_END        
} lin_ota_stage_t;

 
/*! @brief Table to save LIN protocol state structure pointers */
extern const lin_protocol_user_config_t g_lin_protocol_user_cfg_array[LIN_NUM_OF_IFCS];

/*! @brief Table to save LIN protocol state structure pointers */
extern lin_protocol_state_t g_lin_protocol_state_array[LIN_NUM_OF_IFCS];

/*! @brief Frame signal array */
extern uint8_t g_lin_frame_data_buffer[LIN_FRAME_BUF_SIZE];

/*! @brief Table of interface flag handles */
extern uint8_t g_lin_flag_handle_tbl[LIN_FLAG_BUF_SIZE];

void lin_ota_start(void);

#if LIN_NUM_OF_MASTER_IFCS
#define LinOtaStartCallback  lin_ota_start
#else
#define LinOtaStartCallback  NULL
#endif

#endif /* SOURCE_LIN_CFG_H_ */
